/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import reliquary.network.PacketFXConcussiveExplosion;
import reliquary.network.PacketHandler;
import reliquary.util.RandHelper;

public class ConcussiveExplosion
extends Explosion {
    private final Level world;
    private final Vec3 pos;
    protected final Entity exploder;
    private float explosionSize;
    private final Map<Player, Vec3> playerKnockbackMap;
    private final Player shootingEntity;

    public ConcussiveExplosion(Level level, @Nullable Entity entity, @Nullable Player player, Vec3 pos, float size, boolean isFlaming) {
        super(level, entity, null, null, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), size, isFlaming, Explosion.BlockInteraction.BREAK);
        this.world = level;
        this.exploder = entity;
        this.shootingEntity = player;
        this.pos = pos;
        this.explosionSize = size;
        this.playerKnockbackMap = Maps.newHashMap();
    }

    public void m_46061_() {
        float var1 = this.explosionSize;
        this.explosionSize *= 2.0f;
        List var9 = this.world.m_45933_(this.exploder, new AABB(this.pos.m_82520_((double)(-this.explosionSize) - 1.0, (double)(-this.explosionSize) - 1.0, (double)(-this.explosionSize) - 1.0), this.pos.m_82520_((double)this.explosionSize + 1.0, (double)this.explosionSize + 1.0, (double)this.explosionSize + 1.0)));
        for (Entity entity : var9) {
            if (!this.affectEntity(entity)) continue;
            this.attackEntityWithExplosion(this.pos, entity);
        }
        this.explosionSize = var1;
    }

    private void attackEntityWithExplosion(Vec3 var30, Entity entity) {
        double d9;
        double d7;
        double d5;
        double var33;
        double var13 = Math.sqrt(entity.m_20238_(this.pos)) / (double)this.explosionSize;
        if (var13 <= 1.0 && (var33 = Math.sqrt((d5 = entity.m_20185_() - this.pos.m_7096_()) * d5 + (d7 = entity.m_20186_() + (double)entity.m_20192_() - this.pos.m_7098_()) * d7 + (d9 = entity.m_20189_() - this.pos.m_7094_()) * d9)) != 0.0) {
            double var32 = ConcussiveExplosion.m_46064_((Vec3)var30, (Entity)entity);
            double d10 = (1.0 - var13) * var32;
            entity.m_6469_(DamageSource.m_19361_((Entity)this.exploder, (Entity)this.shootingEntity), (float)((int)((d10 * d10 + d10) * 6.0 * (double)(this.explosionSize * 2.0f) + 3.0)));
            entity.m_20256_(entity.m_20184_().m_82520_((d5 /= var33) * d10, (d7 /= var33) * d10, (d9 /= var33) * d10));
        }
    }

    protected boolean affectEntity(Entity entity) {
        return entity instanceof Mob;
    }

    public void m_46075_(boolean spawnParticles) {
        this.world.m_5594_(null, new BlockPos(this.pos), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + RandHelper.getRandomMinusOneToOne(this.world.f_46441_) * 0.2f) * 0.7f);
        if (this.explosionSize >= 2.0f) {
            this.world.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.pos.m_7096_(), this.pos.m_7098_(), this.pos.m_7094_(), 1.0, 0.0, 0.0);
        } else {
            this.world.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.pos.m_7096_(), this.pos.m_7098_(), this.pos.m_7094_(), 1.0, 0.0, 0.0);
        }
    }

    public Map<Player, Vec3> m_46078_() {
        return this.playerKnockbackMap;
    }

    public static void customBusterExplosion(Entity par1Entity, double x, double y, double z, float par8) {
        if (par1Entity.f_19853_.f_46443_) {
            return;
        }
        par1Entity.f_19853_.m_46518_(par1Entity, x, y, z, par8, false, Explosion.BlockInteraction.BREAK);
    }

    public static void customConcussiveExplosion(Entity entity, Player player, Vec3 pos, float size, boolean isFlaming) {
        ConcussiveExplosion var11 = new ConcussiveExplosion(entity.f_19853_, entity, player, pos, size, isFlaming);
        var11.m_46061_();
        var11.m_46075_(false);
        PacketHandler.sendToAllAround(new PacketFXConcussiveExplosion(size, pos), new PacketDistributor.TargetPoint(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 96.0, entity.m_20193_().m_46472_()));
    }

    static void grenadeConcussiveExplosion(Entity entity, Player player, Vec3 pos) {
        GrenadeConcussiveExplosion var11 = new GrenadeConcussiveExplosion(entity.f_19853_, entity, player, pos);
        var11.m_46061_();
        var11.m_46075_(false);
        PacketHandler.sendToAllAround(new PacketFXConcussiveExplosion(4.0f, pos), new PacketDistributor.TargetPoint(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 96.0, entity.m_20193_().m_46472_()));
    }

    public static class GrenadeConcussiveExplosion
    extends ConcussiveExplosion {
        GrenadeConcussiveExplosion(Level world, Entity entity, Player par3Entity, Vec3 pos) {
            super(world, entity, par3Entity, pos, 4.0f, false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean affectEntity(Entity entity) {
            if (super.affectEntity(entity)) {
                if (!(entity instanceof Player)) return true;
            }
            if (!(entity instanceof Player)) return false;
            Player player = (Player)entity;
            if (this.exploder.m_7770_() == null) return false;
            if (!this.exploder.m_7770_().getString().contains(player.m_36316_().getName())) return false;
            return true;
        }
    }
}

